﻿using System.Collections.Generic;
using System;

namespace DictionaryExamples
{
    // Listing 9-7. Rzadka tablica liczb.
    class SparseArray
    {
        private Dictionary<long, double> nonEmptyValues = new Dictionary<long, double>();
        public double this[long index]
        {
            get
            {
                double result;
                nonEmptyValues.TryGetValue(index, out result);
                return result;
            }
            set
            {
                nonEmptyValues[index] = value;
            }
        }

        // Listing 9-9. Przeglądanie zawartości słownika.
        public void ShowArrayContents()
        {
            foreach (var item in nonEmptyValues)
            {
                Console.WriteLine("Klucz: '{0}', wartość: '{1}'",
                    item.Key, item.Value);
            }
        }
    }
}
